```json
{
  "title": "宏",
  "icon": "minecraft:flower_banner_pattern",
  "category": "trickster_lisp:transpiling",
  "ordinal": 2
}
```

转译器支持宏，所定义的宏可在代码中使用。定义格式如下：


**(#def \<宏名\> (\<参数名\>) \<匹配表达式\>)**



;;;;;

之后，宏就可用下述方法调用：


**(#def print (value) (reveal value))**

**(print! 123)**


上方的代码在转换时，会将其展开为**展示之谋略**和内有**123**的子圆，或LISP中的

**(reveal 123)**。

;;;;;

若是在参数列表中使用**贪婪运算符**，宏还可匹配不定数量的参数，例如：

**(#def print (...) (reveal ...))**

**(print! 1 2 3)**


上方的代码会展开为：

**(reveal 1 2 3)**


与普通的参数共同使用时，贪婪运算符必须位于参数列表中的最后一位。

;;;;;

宏是转译器独占的特性，戏法师的法术无法使用LISP的宏，也根本无法将LISP宏转换成法术片段。


向卷轴存储法术时，会将整段代码转换成法术，但同时会将宏保留为附加数据。


转译器载入法术的过程中会尽可能还原宏。

;;;;;

将鼠标悬停在物品上，即可查看其中存有多少LISP宏。


而当宏存储在佩戴着的任意戒指（譬如**宏戒指**）中时，转译器同样能识别到它们，并依此还原出宏调用！


正因此，如需在使用宏时保持代码整洁，可以考虑把宏存到戒指上，再让转译器在转换时帮你还原出来。