```json
{
  "title": "参考文档",
  "icon": "minecraft:book",
  "category": "trickster_lisp:transpiling",
  "ordinal": 1
}
```

本模组使用的语言与LISP很相似，但仍有几点不同。


模组语言的核心要素是**标识符**或**ID**，即映射为戏法师中戏法的名称。


比如说，**caster_reflection** 会映射成**自审之错觉**。

;;;;;

在代码中输入戏法对应的**ID**，然后存入卷轴，即可得到对应的图案。

这也可看作**无参数调用**，或不具参数的函数调用。


用小括号括起**ID**，再用空格分出各参数，即可达成**有参数调用**。

;;;;;

可以在《魔术把戏秘典》中查看各戏法的**ID**⸺就在戏法说明的下方。


若转译器中仅存有法术片段的对应表示，存储时即可将对应片段写入物品。


片段标识外可括有小括号，以便转译器将其识别为法术。

;;;;;

还有若干新函数，可用来直接产生各类戏法师法术片段：


**方块片段**可表示为 **(block_type "\<ID\>")**。


**布尔值片段**可表示为 **true** 和 **false**。


**维度片段**可表示为 **(dimension "\<ID\>")**。

;;;;;

**实体片段**可表示为

**(entity "\<UUID\>")**。


**实体类型片段**可表示为 **(entity_type "\<ID\>")**。


**物品类型片段**可表示为 **(item_type "\<ID\>")**。


**列表片段**可表示为逗号分隔的列表元素，外括中括号，

如 **[ 1, 2, 3 ]**。

;;;;;

**数片段**可表示为整数和浮点数，如 **123** 和 **1.23**。


**图案片段**和**图案字面量**可表示为

**(pattern \<整数\>)** 和 **(pattern_literal \<整数\>)**，

通常来说，在卷轴中绘制后载入转译器即可。

;;;;;

**映射片段**可表示为逗号分隔的键值对，外括大括号，


如 **{**

**0 : true,**

**1 : false**

**}**。


键与冒号、值与冒号间必须留出空格。

;;;;;

**槽位片段**可表示为

**(slot \<槽位索引\>)**、

**(slot \<槽位索引\> \<向量\>)**、

**(slot \<槽位索引\> \<UUID字符串\>)**。


**类型片段**可表示为

**(type "\<法术片段类型\>")**。


**向量片段**可表示为

**(vec \<X\> \<Y\> \<Z\>)**。

;;;;;

**空类型片段**可表示为 **void**。

**空圆**可表示为下划线（**_**）。


转译器还接受下述的特殊函数：


**(get_glyph \<表达式\>)** 会在转换时变为给定的表达式。

也即 **(get_glyph reveal)** 会在转换时变为**展示之谋略**戏法。

;;;;;

**(arg \<1-8\>)** 会分别变为**甲参之错觉**、**乙参之错觉**等。


把这些片段表示方式存到卷轴里试试看吧！